% clear all; clc;

% load('Kernal.mat');

N = 256;            % Port number
f_c = 3.5e9;        % Frequency

Lambda = 3e8/f_c;   % Wavelength

L = 9;              % Path number

W = 10;             % Aperture length per wavelength

x = linspace(0,W*Lambda,N)';

%% Kernal parameters
P = 10;
N_ports = 4;
% sigma2_dB = -20;               % Noise power dB
sigma2 = 10.^(sigma2_dB/10);     % Noise power

T = 100;                        % Number of traning times

S_t_all = zeros(N_ports*P, N, T);
y_t_all = zeros(N_ports*P, T);

%% S_t_Generate
parfor t = 1:T
    S = zeros(P,N);
    if P*N_ports<=N
        Index_act = randperm(N,P*N_ports);
    else
        Index_act = [randperm(N,N),randi(N,1,P*N_ports-N)];
    end
    for p = 1:P
        S(p,Index_act((p-1)*N_ports + 1:1:p*N_ports)) = 1;
    end

    S_t = zeros(N_ports*P, N);
    for idx = 1:P
        indActivated = find(S(idx, :));
        for p = 1:N_ports
            S_t((idx-1)*N_ports+p, indActivated(p)) = 1;
        end
    end

    %% h_t, y_t_Generate
    h_t = SV_channel(x,Lambda,L);

    y_t = S_t*h_t + sqrt(sigma2/2)*(randn(P*N_ports,1)+1j*randn(P*N_ports,1));

    S_t_all(:,:,t) = S_t;
    y_t_all(:,t) = y_t;
end

%% LMLF calculate
% eta = [0.00001:0.00001:0.01];
% eta = (Lambda/2/pi + [-0.013:0.001:0.01]);

eta = (Lambda/2/pi + [-0.0001:0.00001:0.0001]);

Kernal_exp = zeros(N,N);
% mtx_exp = -(abs([1:N]-[1:N]')*W*Lambda/(N-1)).^2;
mtx_exp = abs([1:N]-[1:N]')*(x(2)-x(1));

LMLF_exp = zeros(length(eta),1);
LMLF_J0 = zeros(length(eta),1);

for iter = 1:length(eta)

    Kernal_exp = exp(-mtx_exp.^2/eta(iter));
    Kernal_J0 = besselj(0,mtx_exp/eta(iter));

    for t = 1:T
        S_t = reshape(S_t_all(:,:,t),N_ports*P, N);
        y_t = reshape(y_t_all(:,t),N_ports*P,1);
        
        LMLF_exp(iter) = LMLF_exp(iter) - y_t'*(S_t*Kernal_exp*S_t'+sigma2*eye(P*N_ports))*y_t - log(det(S_t*Kernal_exp*S_t'+sigma2*eye(P*N_ports)));
        LMLF_J0(iter) = LMLF_J0(iter) - y_t'*(S_t*Kernal_J0*S_t'+sigma2*eye(P*N_ports))*y_t - log(det(S_t*Kernal_J0*S_t'+sigma2*eye(P*N_ports)));
    end

end

LMLF_exp = abs(LMLF_exp)/T;
LMLF_J0 = abs(LMLF_J0)/T;

% figure;
% plot(eta,LMLF_exp);

[~,max_index] = max(real(LMLF_exp));
Kernal_exp = exp(-10*mtx_exp.^2/eta(max_index));

[~,max_index] = max(real(LMLF_J0));
Kernal_J0 = besselj(0,mtx_exp/eta(max_index));

save(['Kernal_SV_learning/Kernal_' num2str(sigma2_dB) '.mat'],'N','x','Kernal_exp','Kernal_J0');


